<?php
// The source code packaged with this file is Free Software, Copyright (C) 2005 by
// Ricardo Galli <gallir at uib dot es>.
// It's licensed under the AFFERO GENERAL PUBLIC LICENSE unless stated otherwise.
// You can get copies of the licenses here:
// 		http://www.affero.org/oagpl.html
// AFFERO GENERAL PUBLIC LICENSE is also included in the file called "COPYING".

include_once('Smarty.class.php');
$main_smarty = new Smarty;

include('config.php');
include(mnminclude.'html1.php');
include(mnminclude.'link.php');
include(mnminclude.'smartyvariables.php');

$requestID = $_REQUEST['id'];
$requestTitle = $_REQUEST['title'];

if(isset($requestTitle)){
	$requestID = $db->get_var("SELECT link_id FROM " . table_links . " WHERE `link_title_url` = '$requestTitle';");
}else{
	if(!is_numeric($requestID)){
		$requestID = $db->get_var("SELECT link_id FROM " . table_links . " WHERE `link_title_url` = '$requestID';");
	}
}

if(!isset($_REQUEST['email_to_submit'])){ // we're not submitting the form
	if(!isset($_REQUEST['draw'])){ // this is not a request to draw the form?
		if(is_numeric($requestID)) {
			$id = $requestID;
			$link = new Link;
			$link->id=$requestID;
			$link->read();
		
		  // assign email details to smarty
			$main_smarty->assign('original_id', $requestID);		
			$main_smarty->assign('link_title', $link->title);
			$main_smarty->assign('link_content', $link->content);
			$main_smarty->assign('link_url', my_base_url . getmyurl("story", $link->id)); // internal link to the comments page
			$main_smarty->assign('user_logged_in', $current_user->user_login);		
			$main_smarty->assign('email_subject', Email_Subject . $link->title);
			$main_smarty->assign('Default_Message', Default_Message);		
			$main_smarty->assign('Included_Text_Part1', Included_Text_Part1);
			$main_smarty->assign('Included_Text_Part2', Included_Text_Part2);
			
		  // pagename
		  define('pagename', 'recommend'); 
		$main_smarty->assign('pagename', pagename);	
			
			//show the template	
			$main_smarty->assign('tpl_center', $the_template . '/recommend');
			$main_smarty->display($the_template . '/pligg.tpl');
		}
	} else { // this is a request to draw the form 
		if($_REQUEST['draw'] == "small"){ // small form -- the form's html is in recommend_small.tpl
			$htmlid = $_REQUEST['htmlid'];
			$linkid = $_REQUEST['linkid'];

			$main_smarty->assign('ts_random', rand(10000000, 99999999));
			$main_smarty->assign('Default_Message', Default_Message);
			$main_smarty->assign('link_shakebox_index', $htmlid);
			$main_smarty->assign('link_id', $linkid);
			$main_smarty->assign('instpath', my_base_url . my_pligg_base . "/");
			$main_smarty->display($the_template . '/recommend_small.tpl');
		
		}
	}
} else { // we're submitting the form and sending the emails
	Global $current_user, $db;

	if(!$current_user->authenticated) {
		echo '<br/><p><span class="error">'.$main_smarty->get_config_vars('PLIGG_Visual_Recommend_Logged_In').'</span></p>';
		die();
	}

	$sql = 'SELECT `last_email_friend` FROM `' . table_users . '` WHERE `user_login` = "'.$current_user->user_login.'"';
	$last_email = $db->get_var($sql);

	$time_since_last_email = time() - strtotime($last_email);

	if($time_since_last_email < Recommend_Time_Limit){
		echo '<br/><p><span class="error">'.$main_smarty->get_config_vars('PLIGG_Visual_Recommend_Limit').'</span></p>';
		die();
	}

	$requestID = $_REQUEST['original_id'];
	if(is_numeric($requestID)) {
		$id = $requestID;
		$link = new Link;
		$link->id=$requestID;
		$link->read();

		$link_url = my_base_url . getmyurl("story", $link->id);
		$headers = 'From: ' . Send_From_Email . "\r\n";

		$to = "";
		
		$cansend = 0;
		$addresses = explode(", ", $_REQUEST['email_address']);
		for($i = 0; $i <= count(addresses); $i++){
			if($addresses[$i] != ""){
				if (!check_email_address($addresses[$i])) {
					$cansend = -100;
					echo '<br>Error: ' . $addresses[$i] . ' is not a valid email address.<br>';
				} else {
					$cansend = $cansend + 10;
					//$headers .= 'Bcc: ' . $addresses[$i] . "\r\n";
					$headers .= "Bcc: " . $addresses[$i] . "\n";
				}
			}
		}
		$headers .= "Content-Type: text/plain; charset=utf-8\n";

		if(isset($_REQUEST['email_subject'])){
			$subject = $_REQUEST['email_subject'];
		} else {
			$subject = Email_Subject . $link->title;
		}
		if(isset($_REQUEST['email_message'])){
			$message = stripslashes($_REQUEST['email_message']);
		} else {
			$message = Default_Message;
		} 
		if ($current_user->user_login){
		$body = $message . "\r\n\r\n" . Included_Text_Part1 ." ". $current_user->user_login .",". Included_Text_Part2 ."\r\n\r\n".$link->title." - " .strip_tags($link->content)."\r\n\r\n" ."Here is a link to the story: ". $link_url;}
		else{
		$body = $message . "\r\n\r\n" . Included_Text_Part1 ." Anonymous,". Included_Text_Part2 ."\r\n\r\n".$link->title." - " .strip_tags($link->content)."\r\n\r\n" ."Here is a link to the story: ". $link_url;}

	
		if(isset($_REQUEST['backup'])){
			$backup = $_REQUEST['backup'];
		} else {
			$backup = 2;
		}
		
		if($cansend >= 10){
		  $addresses = explode(", ", $_REQUEST['email_address']);

		  mailer_start();
		  $mailer = new PliggMailer($subject, $body, Send_From_Email, $addresses);
		  //$mailer->debug();
		  $mailer->send();
		  
		  die();
		  
			if (mail($to, $subject, $body, $headers)){
				$sql = 'UPDATE `' . table_users . '` SET `last_email_friend` = FROM_UNIXTIME('.time().') WHERE `user_login` = "'.$current_user->user_login.'"';
				$db->query($sql);
				echo "<br>Sent! <br><br>";
				if($backup > 0){echo '<input type=button onclick="window.history.go(-'.$backup.')" value="return">';}
			}else{
				echo '<br/><p><span class="error">'.$main_smarty->get_config_vars('PLIGG_PassEmail_SendFail').'</span></p>';
			}
		} else {
			echo '<br/><p><span class="error">'.$main_smarty->get_config_vars('PLIGG_PassEmail_SendFail').'</span></p>';
		}
	} else {
		echo '<br/><p><span class="error">'.$main_smarty->get_config_vars('PLIGG_PassEmail_SendFail').'</span></p>';
	}
}
?>
